/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	DealerSay
**
** DESCRIPTION:	Manages gameplay messages to players
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef DEALERSAY_H
#define DEALERSAY_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "theStringManager.h"
#include "../Villagers/VillagerBio.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int DealerSay_c_iMaxMessageLength = 256;
const int DealerSay_c_iMessageDuration = 5;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CDealerSay
{
private:

	//class data
	char			m_sMessage[DealerSay_c_iMaxMessageLength];
	unsigned int	m_uiTimer;

	//class methods
	//setup
	public:		CDealerSay(void);
	public:		void Reset();

	//process
	public:		void Update();
	public:		void Say(const StringId eString, const int iValue = -1);
	public:		void Say(const StringId eString, const char *sData);
	public:		void Say(const StringId eString, EGender eGender);
	public:		void Say(const StringId eString, const char *sName, EGender eGender, const char *sName2 = 0);
	public:		void Say(const char *sData);

	//access
	public:		const char *Message() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CDealerSay		DealerSay;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/